<?php

namespace Drupal\rest_easy_api_keys\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\user\UserInterface;

/**
 * Form for creating and managing a user's API keys.
 *
 * @package Drupal\rest_easy_api_keys\Form
 */
class APIKeysForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'rest_easy_api_keys_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, ?UserInterface $user = NULL) {
    $form['user'] = [
      '#type' => 'value',
      '#value' => $user,
    ];

    $form['description'] = [
      '#markup' => $this->t('<p>Use this form to manage your API keys.</p>'),
    ];

    $api_keys = [];
    if (isset($user->rest_easy_api_keys[0]->value) && $user->rest_easy_api_keys[0]->value) {
      foreach ($user->rest_easy_api_keys as $api_key) {
        $api_key = trim($api_key->value);
        if ($api_key) {
          $api_keys[] = $api_key;
        }
      }
    }
    $api_keys = implode("\n", $api_keys);
    $form['rest_easy_api_keys'] = [
      '#type' => 'textarea',
      '#default_value' => $api_keys,
      '#description' => $this->t('<a class="generate-api-key" href="#">Generate a new API key.</a> List one API key per line.'),
    ];

    $form['save'] = [
      '#type' => 'submit',
      '#value' => $this->t('Save'),
    ];

    $form['#attached']['library'][] = 'rest_easy_api_keys/api_keys_form';

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {

  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $api_keys = [];
    foreach (explode("\n", $form_state->getValue('rest_easy_api_keys')) as $api_key) {
      $api_key = trim($api_key);
      if ($api_key) {
        $api_keys[] = $api_key;
      }
    }
    $form_state->getValue('user')
      ->set('rest_easy_api_keys', $api_keys)
      ->save();
  }

}
