<?php

namespace Drupal\rest_easy_example\Plugin\rest_easy\API;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\rest_easy\Attribute\RESTEasyAPI;
use Drupal\rest_easy\Plugin\APIBase;

/**
 * An example REST Easy API plugin.
 *
 * @package Drupal\rest_easy_example\Plugin\rest_easy\API
 */
#[RESTEasyAPI(
  id: "rest_easy_example",
  label: new TranslatableMarkup("REST Easy Example API"),
  auth: ["cookie"],
  base_path: "/rest-easy-example",
  description: new TranslatableMarkup("An example REST Easy API that can be used as a template for your own."),
  permission: "access content",
  produces: ["application/json"],
  tags: [
    "Example" => new TranslatableMarkup("Endpoints intended as examples."),
  ],
  version: "1"
)]
class ExampleAPI extends APIBase {

  /**
   * {@inheritdoc}
   */
  public function routes(): array {
    $routes = parent::routes();
    // By default, an API will register one route for each endpoint. You can
    // override this method to register additional routes or modify existing
    // ones.
    return $routes;
  }

}
