<?php

namespace Drupal\rest_easy_openapi\Plugin\openapi\OpenApiGenerator;

use Drupal\openapi\Plugin\openapi\OpenApiGeneratorBase;
use Drupal\rest_easy\Plugin\APIInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * A generator that converts REST Easy APIs into OpenAPI documentation.
 *
 * @OpenApiGenerator(
 *   id = "rest_easy",
 *   deriver = "Drupal\rest_easy_openapi\Plugin\Derivative\RESTEasyApiDeriver"
 * )
 *
 * @package Drupal\rest_easy_openapi\Plugin\openapi\OpenApiGenerator
 */
class RESTEasyApiGenerator extends OpenApiGeneratorBase {

  /**
   * The API plugin.
   *
   * @var \Drupal\rest_easy\Plugin\APIInterface
   */
  protected APIInterface $apiPlugin;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    $instance = parent::create($container, $configuration, $plugin_id, $plugin_definition);
    $plugin_id_parts = explode(':', $plugin_id);
    $instance->apiPlugin = $container->get('plugin.manager.rest_easy.api')
      ->createInstance($plugin_id_parts[1]);
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  protected function getApiDescription() {
    return $this->apiPlugin->getDescription();
  }

  /**
   * {@inheritdoc}
   */
  public function getApiName() {
    return $this->apiPlugin->getApiName();
  }

  /**
   * {@inheritdoc}
   */
  public function getBasePath() {
    return $this->apiPlugin->getBasePath();
  }

  /**
   * {@inheritdoc}
   */
  protected function getInfo() {
    return $this->apiPlugin->getInfo();
  }

  /**
   * {@inheritdoc}
   */
  protected function getJsonSchema($described_format, $entity_type_id, $bundle_name = NULL) {
    return $this->apiPlugin->getJsonSchema($described_format, $entity_type_id, $bundle_name = NULL);
  }

  /**
   * {@inheritdoc}
   */
  public function getPaths() {
    return $this->apiPlugin->getPaths();
  }

  /**
   * {@inheritdoc}
   */
  public function getProduces() {
    $definition = $this->apiPlugin->getPluginDefinition();
    return $definition['produces'];
  }

  /**
   * {@inheritdoc}
   */
  public function getSecurity() {
    $security = [];
    foreach ($this->getSecurityDefinitions() as $key => $security_definition) {
      $security[] = [$key => []];
    }
    return $security;
  }

  /**
   * {@inheritdoc}
   */
  public function getSecurityDefinitions() {
    return $this->apiPlugin->getSecurityDefinitions();
  }

  /**
   * {@inheritdoc}
   */
  public function getSpecification() {
    $specification = parent::getSpecification();
    $parameters_and_definitions = [];
    if (($parameters = $this->apiPlugin->getParameters())) {
      $parameters_and_definitions['parameters'] = $parameters;
    }
    if (($definitions = $this->apiPlugin->getSchemaDefinitions())) {
      $parameters_and_definitions['definitions'] = $definitions;
    }
    if ($parameters_and_definitions) {
      $paths_index = array_search('paths', array_keys($specification));
      $specification = array_slice($specification, 0, $paths_index, TRUE) + $parameters_and_definitions + array_slice($specification, $paths_index, count($specification) - $paths_index, TRUE);
    }
    return $specification;
  }

  /**
   * {@inheritdoc}
   */
  public function getTags() {
    return $this->apiPlugin->getTags();
  }

}
