<?php

namespace Drupal\rest_easy\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\rest_easy\Plugin\APIInterface;

/**
 * An event that is dispatched when API routes are generated.
 *
 * @package Drupal\rest_easy\Event
 */
class APIRoutesEvent extends Event {
  public const EVENT_NAME = 'rest_easy_api_routes_event';

  /**
   * The API plugin that generated the routes.
   *
   * @var \Drupal\rest_easy\Plugin\APIInterface
   */
  public APIInterface $api;

  /**
   * The routes that were generated.
   *
   * @var \Symfony\Component\Routing\Route[]
   */
  public array $routes;

  /**
   * Constructs a new APIRoutesEvent object.
   *
   * @param \Drupal\rest_easy\Plugin\APIInterface $api
   *   The API plugin that generated the routes.
   * @param array $routes
   *   The routes that were generated.
   */
  public function __construct(APIInterface $api, array $routes) {
    $this->api = $api;
    $this->routes = $routes;
  }

}
