<?php

namespace Drupal\rest_easy\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\Core\Access\AccessResultInterface;
use Drupal\rest_easy\Plugin\EndpointInterface;

/**
 * An event that is dispatched when an endpoint is accessed.
 *
 * @package Drupal\rest_easy\Event
 */
class EndpointAccessEvent extends Event {
  public const EVENT_NAME = 'rest_easy_endpoint_access_event';

  /**
   * The endpoint plugin being accessed.
   *
   * @var \Drupal\rest_easy\Plugin\EndpointInterface
   */
  public EndpointInterface $endpoint;

  /**
   * The access result about to be returned.
   *
   * @var \Drupal\Core\Access\AccessResultInterface
   */
  public AccessResultInterface $result;

  /**
   * Constructs a new EndpointAccessEvent object.
   *
   * @param \Drupal\rest_easy\Plugin\EndpointInterface $endpoint
   *   The endpoint plugin being accessed.
   * @param \Drupal\Core\Access\AccessResultInterface $result
   *   The access result about to be returned.
   */
  public function __construct(EndpointInterface $endpoint, AccessResultInterface $result) {
    $this->endpoint = $endpoint;
    $this->result = $result;
  }

}
