<?php

namespace Drupal\rest_easy\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Attributes defining a REST Easy API plugin.
 *
 * @package Drupal\rest_easy\Attribute
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class RESTEasyAPI extends Plugin {

  /**
   * Constructs a new RESTEasyAPI object.
   *
   * @param string $id
   *   The machine name of the API.
   * @param string $label
   *   The human-readable name of the API.
   * @param array $allowed_origins
   *   (optional) A list of domains that can access the API. Leave empty to
   *   allow any domain.
   * @param array $auth
   *   (optional) A list of authentication plugins that can be used with the
   *   API. Defaults to ["cookie"].
   * @param string $base_path
   *   (optional) The relative path shared by the API's endpoints (e.g.,
   *   "/some-api/v1").
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $description
   *   (optional) A brief description of the API.
   * @param string $permission
   *   (optional) The permission required to access any endpoint on the API.
   *   Endpoint permissions override this default.
   * @param array $produces
   *   (optional) A list of MIME types the API can produce.
   * @param array $tags
   *   (optional) An associative array of tag descriptions indexed by tag
   *   names.
   * @param string $version
   *   (optional) The version number of the API.
   * @param string|null $deriver
   *   (optional) The deriver class.
   */
  public function __construct(
    public readonly string $id,
    public readonly string $label,
    public readonly array $allowed_origins = [],
    public readonly array $auth = ['cookie'],
    public readonly string $base_path = '/',
    public readonly ?TranslatableMarkup $description = NULL,
    public readonly string $permission = '',
    public readonly array $produces = ['application/json'],
    public readonly array $tags = [],
    public readonly string $version = '1',
    public readonly ?string $deriver = NULL,
  ) {

  }

}
