<?php

namespace Drupal\rest_easy\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\rest_easy\Plugin\EndpointInterface;
use Symfony\Component\Routing\Route;

/**
 * An event that is dispatched when an endpoint route is generated.
 *
 * @package Drupal\rest_easy\Event
 */
class EndpointRouteEvent extends Event {
  public const EVENT_NAME = 'rest_easy_endpoint_route_event';

  /**
   * The endpoint plugin.
   *
   * @var \Drupal\rest_easy\Plugin\EndpointInterface
   */
  public EndpointInterface $endpoint;

  /**
   * The route for the endpoint.
   *
   * @var \Symfony\Component\Routing\Route
   */
  public Route $route;

  /**
   * Constructs a new EndpointRouteEvent object.
   *
   * @param \Drupal\rest_easy\Plugin\EndpointInterface $endpoint
   *   The endpoint plugin.
   * @param \Symfony\Component\Routing\Route $route
   *   The route for the endpoint.
   */
  public function __construct(EndpointInterface $endpoint, Route $route) {
    $this->endpoint = $endpoint;
    $this->route = $route;
  }

}
