<?php

namespace Drupal\rest_easy\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\rest_easy\Plugin\ParameterInterface;

/**
 * An event that is dispatched when an parameter value is validated.
 *
 * @package Drupal\rest_easy\Event
 */
class ParameterValidateEvent extends Event {
  public const EVENT_NAME = 'rest_easy_parameter_validate_event';

  /**
   * The parameter plugin.
   *
   * @var \Drupal\rest_easy\Plugin\ParameterInterface
   */
  public ParameterInterface $parameter;

  /**
   * Validation errors that occurred.
   *
   * @var array
   */
  public array $errors;

  /**
   * Constructs a new ParameterValidateEvent object.
   *
   * @param \Drupal\rest_easy\Plugin\ParameterInterface $parameter
   *   The parameter plugin.
   * @param array $errors
   *   Validation errors that occurred.
   */
  public function __construct(ParameterInterface $parameter, array $errors) {
    $this->parameter = $parameter;
    $this->errors = $errors;
  }

}
