<?php

namespace Drupal\rest_easy_api_keys\EventSubscriber;

use Drupal\rest_easy\Event\APISecurityDefinitionsEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * An event subscriber to alter OpenAPI security definitions.
 *
 * @package Drupal\rest_easy_api_keys\EventSubscriber
 */
class APISecuritySubscriber implements EventSubscriberInterface {

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    return [
      APISecurityDefinitionsEvent::EVENT_NAME => 'onSecurityDefinitions',
    ];
  }

  /**
   * React to the security definitions event.
   *
   * @param \Drupal\rest_easy\Event\APISecurityDefinitionsEvent $event
   *   The event object.
   */
  public function onSecurityDefinitions(APISecurityDefinitionsEvent $event) {

    // Check if the API or any of its endpoints use the REST Easy API key
    // authentication method.
    $definition = $event->api->getPluginDefinition();
    $api_key_auth = isset($definition['auth'][0]) && in_array('rest_easy_api_key', $definition['auth']);
    if (!$api_key_auth) {
      foreach ($event->api->endpoints as $endpoint) {
        $endpoint_definition = $endpoint->getPluginDefinition();
        if (isset($endpoint_definition['auth'][0]) && in_array('rest_easy_api_key', $endpoint_definition['auth'])) {
          $api_key_auth = TRUE;
          break;
        }
      }
    }
    if ($api_key_auth) {
      $event->definitions['api_key_header'] = [
        'in' => 'header',
        'name' => 'x-api-key',
        'type' => 'apiKey',
      ];
      $event->definitions['api_key_query'] = [
        'in' => 'query',
        'name' => 'apiKey',
        'type' => 'apiKey',
      ];
    }
  }

}
