<?php

namespace Drupal\rest_easy_example\Plugin\rest_easy\Parameter;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\rest_easy\Attribute\RESTEasyParameter;
use Drupal\rest_easy\Plugin\ParameterBase;

/**
 * An example REST Easy parameter plugin.
 *
 * @package Drupal\rest_easy_example\Plugin\rest_easy\Parameter
 */
#[RESTEasyParameter(
  api: "rest_easy_example",
  id: "pretty",
  type: "boolean",
  default: FALSE,
  description: new TranslatableMarkup("Whether to return pretty JSON."),
  in: "query",
  required: FALSE
)]
class PrettyParameter extends ParameterBase {

  /**
   * {@inheritdoc}
   */
  public function get(): mixed {
    $value = parent::get();
    // Parameters will populate based in the "in" property of their plugin
    // attributes:
    // - body: The value will be parsed from the JSON of the request body.
    // - formData: The value will be parsed from the request.
    // - header: The value will be parsed from the request headers.
    // - path: The value will be parsed from the route path.
    // - query: The value will be parsed from the query string.
    //
    // If the parameter value is not provided, the default value will be used.
    // You can override this function if your parameter's value requires
    // additional processing.
    return $value;
  }

  /**
   * {@inheritdoc}
   */
  public function validate($value): array {
    $errors = parent::validate($value);

    // Parameters are validated by checking their type and whether they are
    // required. You can override the validate() method to add custom
    // validation logic. If the parameter is invalid, return an array of error
    // messages. If the parameter is valid, return an empty array.
    return $errors;
  }

}
