<?php

namespace Drupal\rest_easy\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Attributes defining a REST Easy endpoint plugin.
 *
 * @package Drupal\rest_easy\Attribute
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class RESTEasyEndpoint extends Plugin {

  /**
   * Constructs a new RESTEasyEndpoint object.
   *
   * @param string $api
   *   The machine name of the API the endpoint is part of.
   * @param string $id
   *   The machine name of the endpoint.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $label
   *   The human-readable name of the endpoint.
   * @param string $path
   *   The relative path of the endpoint beyond the API's base path (e.g.,
   *   "/some-endpoint").
   * @param array $allowed_origins
   *   (optional) A list of domains that can access the endpoint. Leave empty
   *   to allow any domain. This will override any default allowed origins
   *   supplied by the API.
   * @param array $auth
   *   (optional) A list of authentication plugins that can be used with the
   *   API. This will override any default auth plugins supplied by the API.
   * @param int $cache_lifetime
   *   (optional) The maximum number of seconds an API response will be cached.
   *   Defaults to 3600 (one hour).
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $description
   *   (optional) A brief description of the endpoint.
   * @param array $methods
   *   (optional) An array of HTTP methods (e.g., GET, POST) the endpoint
   *   accepts. Defaults to GET.
   * @param array $parameters
   *   (optional) An array of machine names for parameter plugins the endpoint
   *   can use.
   * @param string $permission
   *   (optional) The permission required to access the endpoint. This will
   *   override any default permission supplied by the API.
   * @param array $responses
   *   (optional) An associative array of schema definitions the endpoint might
   *   return indexed by their HTTP status codes. Override schemaDefinitions()
   *   to define your own schema(s), or use the built-in "Status" schema.
   *   Defaults to [200 => 'Status', 400 => 'Status'].
   * @param array $tags
   *   (optional) An array of tag names used to group endpoints in the OpenAPI
   *   documentation.
   * @param string|null $deriver
   *   (optional) The deriver class.
   */
  public function __construct(
    public readonly string $api,
    public readonly string $id,
    public readonly TranslatableMarkup $label,
    public readonly string $path,
    public readonly array $allowed_origins = [],
    public readonly array $auth = [],
    public readonly int $cache_lifetime = 3600,
    public readonly ?TranslatableMarkup $description = NULL,
    public readonly array $methods = ['GET'],
    public readonly array $parameters = [],
    public readonly string $permission = '',
    public readonly array $responses = [200 => 'Status', 400 => 'Status'],
    public readonly array $tags = [],
    public readonly ?string $deriver = NULL,
  ) {

  }

}
