<?php

namespace Drupal\rest_easy\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Attributes defining a REST Easy parameter plugin.
 *
 * @package Drupal\rest_easy\Attribute
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class RESTEasyParameter extends Plugin {

  /**
   * Constructs a new RESTEasyParameter object.
   *
   * @param string $api
   *   The machine name of the API the parameter is part of.
   * @param string $id
   *   The machine name of the parameter.
   * @param string $type
   *   The type of data stored in the parameter: array, boolean, integer,
   *   number, or string
   *   @todo Add support for file parameters.
   * @param mixed $default
   *   The default value to use when the request doesn't specify the parameter
   *   value.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $description
   *   (optional) A brief description of the parameter.
   * @param array $enum
   *   (optional) An array of all allowed parameter values.
   * @param bool $exclusiveMaximum
   *   (optional) Whether the parameter can be equal to the maximum (TRUE) or
   *   must be less than the maximum (FALSE)
   * @param bool $exclusiveMinimum
   *   (optional) Whether the parameter can be equal to the minimum (TRUE) or
   *   must be greater than the minimum (FALSE)
   * @param string|null $format
   *   (optional) A hint about the expected format of the parameter, such as
   *   date-time or email.
   * @param string $in
   *   (optional) Where the parameter is found: body, formData, header, path,
   *   or query.
   * @param float|int|null $maximum
   *   (optional) The maximum value allowed for an integer or number parameter.
   * @param int|null $maxItems
   *   (optional) The maximum number of items allowed for an array parameter.
   * @param int|null $maxLength
   *   (optional) The maximum number of characters allowed for a string
   *   parameter.
   * @param float|int|null $minimum
   *   (optional) The minimum value allowed for an integer or number parameter.
   * @param int|null $minLength
   *   (optional) The minimum number of characters allowed for a string
   *   parameter.
   * @param string|null $pattern
   *   (optional) A regular expression that a string parameter's value must
   *   match.
   * @param bool $required
   *   (optional) Whether the parameter is required.
   * @param string|null $deriver
   *   (optional) The deriver class.
   */
  public function __construct(
    public readonly string $api,
    public readonly string $id,
    public readonly string $type,
    public readonly mixed $default = NULL,
    public readonly ?TranslatableMarkup $description = NULL,
    public readonly array $enum = [],
    public readonly bool $exclusiveMaximum = FALSE,
    public readonly bool $exclusiveMinimum = FALSE,
    public readonly string|null $format = NULL,
    public readonly string $in = 'query',
    public readonly float|int|null $maximum = NULL,
    public readonly int|null $maxItems = NULL,
    public readonly int|null $maxLength = NULL,
    public readonly float|int|null $minimum = NULL,
    public readonly int|null $minLength = NULL,
    public readonly string|null $pattern = NULL,
    public readonly bool $required = FALSE,
    public readonly ?string $deriver = NULL,
  ) {

  }

}
