<?php

namespace Drupal\rest_easy\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\rest_easy\Plugin\APIInterface;

/**
 * An event that is dispatched when API security definitions are generated.
 *
 * @package Drupal\rest_easy\Event
 */
class APISecurityDefinitionsEvent extends Event {
  public const EVENT_NAME = 'rest_easy_api_security_definitions_event';

  /**
   * The API plugin that generated the security definitions.
   *
   * @var \Drupal\rest_easy\Plugin\APIInterface
   */
  public APIInterface $api;

  /**
   * The security definitions that were generated.
   *
   * @var array
   */
  public array $definitions;

  /**
   * Constructs a new APISecurityDefinitionsEvent object.
   *
   * @param \Drupal\rest_easy\Plugin\APIInterface $api
   *   The API plugin that generated the security definitions.
   * @param array $definitions
   *   The security definitions that were generated.
   */
  public function __construct(APIInterface $api, array $definitions) {
    $this->api = $api;
    $this->definitions = $definitions;
  }

}
