<?php

namespace Drupal\rest_easy\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\rest_easy\Plugin\APIInterface;

/**
 * An event that is dispatched when API security entries are generated.
 *
 * @package Drupal\rest_easy\Event
 */
class APISecurityEvent extends Event {
  public const EVENT_NAME = 'rest_easy_api_security_event';

  /**
   * The API plugin that generated the security entries.
   *
   * @var \Drupal\rest_easy\Plugin\APIInterface
   */
  public APIInterface $api;

  /**
   * The security entries that were generated.
   *
   * @var array
   */
  public array $security;

  /**
   * Constructs a new APISecurityEvent object.
   *
   * @param \Drupal\rest_easy\Plugin\APIInterface $api
   *   The API plugin that generated the security entries.
   * @param array $security
   *   The security entries that were generated.
   */
  public function __construct(APIInterface $api, array $security) {
    $this->api = $api;
    $this->security = $security;
  }

}
