<?php

namespace Drupal\rest_easy\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\rest_easy\Plugin\EndpointInterface;

/**
 * An event that is dispatched when headers are sent with an endpoint response.
 *
 * @package Drupal\rest_easy\Event
 */
class EndpointHeadersEvent extends Event {
  public const EVENT_NAME = 'rest_easy_endpoint_headers_event';

  /**
   * The endpoint plugin being called.
   *
   * @var \Drupal\rest_easy\Plugin\EndpointInterface
   */
  public EndpointInterface $endpoint;

  /**
   * The headers about to be sent with the response.
   *
   * @var array
   */
  public array $headers;

  /**
   * Constructs a new EndpointHeadersEvent object.
   *
   * @param \Drupal\rest_easy\Plugin\EndpointInterface $endpoint
   *   The endpoint plugin being called.
   * @param array $headers
   *   The headers about to be sent with the response.
   */
  public function __construct(EndpointInterface $endpoint, array $headers) {
    $this->endpoint = $endpoint;
    $this->headers = $headers;
  }

}
