<?php

namespace Drupal\rest_easy\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\rest_easy\Plugin\ParameterInterface;

/**
 * An event that is dispatched when an parameter value is retrieved.
 *
 * @package Drupal\rest_easy\Event
 */
class ParameterGetEvent extends Event {
  public const EVENT_NAME = 'rest_easy_parameter_get_event';

  /**
   * The parameter plugin.
   *
   * @var \Drupal\rest_easy\Plugin\ParameterInterface
   */
  public ParameterInterface $parameter;

  /**
   * The value about to be passed.
   *
   * @var mixed
   */
  public mixed $value;

  /**
   * Constructs a new ParameterGetEvent object.
   *
   * @param \Drupal\rest_easy\Plugin\ParameterInterface $parameter
   *   The parameter plugin.
   * @param mixed $value
   *   The value about to be passed.
   */
  public function __construct(ParameterInterface $parameter, mixed $value) {
    $this->parameter = $parameter;
    $this->value = $value;
  }

}
