<?php

namespace Drupal\rest_easy\Plugin;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\rest_easy\Attribute\RESTEasyAPI;

/**
 * A plugin manager service for REST Easy APIs.
 *
 * @see plugin_api
 * @package Drupal\rest_easy\Plugin
 */
class APIManager extends DefaultPluginManager {

  /**
   * Constructs a new APIPluginManager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/rest_easy/API',
      $namespaces,
      $module_handler,
      'Drupal\rest_easy\Plugin\APIInterface',
      RESTEasyAPI::class
    );
    $this->alterInfo('rest_easy_api');
    $this->setCacheBackend($cache_backend, 'rest_easy_api_plugins');
  }

}
