<?php

namespace Drupal\rest_easy\Plugin;

use Drupal\Core\Config\ConfigFactoryInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * A base class for building endpoints that access configuration entities.
 *
 * @package Drupal\rest_easy\Plugin
 */
abstract class ConfigEndpointBase extends EndpointBase {

  /**
   * Config factory service.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    $instance = parent::create($container, $configuration, $plugin_id, $plugin_definition);
    $instance->setExtraProperties($container->get('config.factory'));
    return $instance;
  }

  /**
   * Add extra dependencies to the plugin.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $configFactory
   *   Config factory service.
   */
  public function setExtraProperties(ConfigFactoryInterface $configFactory) {
    $this->configFactory = $configFactory;
  }

}
