<?php

namespace Drupal\rest_easy\Plugin;

use Drupal\Core\Database\Connection;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Base class for endpoints that use a database connection.
 *
 * @package Drupal\rest_easy\Plugin
 */
abstract class DatabaseEndpointBase extends EndpointBase {

  /**
   * Database service.
   *
   * @var \Drupal\Core\Database\Connection
   */
  protected $database;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    $instance = parent::create($container, $configuration, $plugin_id, $plugin_definition);
    $instance->addDatabase($container->get('database'));
    return $instance;
  }

  /**
   * Inject the database connection into the endpoint.
   *
   * @param \Drupal\Core\Database\Connection $database
   *   Database service.
   */
  public function addDatabase(Connection $database) {
    $this->database = $database;
  }

}
