<?php

namespace Drupal\rest_easy\Plugin;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\rest_easy\Attribute\RESTEasyEndpoint;

/**
 * A plugin manager service for REST Easy endpoints.
 *
 * @see plugin_api
 * @package Drupal\rest_easy\Plugin
 */
class EndpointManager extends DefaultPluginManager {

  /**
   * Constructs a new EndpointPluginManager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/rest_easy/Endpoint',
      $namespaces,
      $module_handler,
      'Drupal\rest_easy\Plugin\EndpointInterface',
      RESTEasyEndpoint::class
    );
    $this->alterInfo('rest_easy_endpoint');
    $this->setCacheBackend($cache_backend, 'rest_easy_endpoint_plugins');
  }

}
