<?php

namespace Drupal\rest_easy\Plugin;

use Drupal\Component\Plugin\PluginInspectionInterface;

/**
 * An interface for creating REST Easy parameter plugins.
 *
 * @package Drupal\rest_easy\Plugin
 */
interface ParameterInterface extends PluginInspectionInterface {

  /**
   * Retrieve the value of the parameter from the request.
   *
   * @return mixed
   *   The value of the parameter.
   */
  public function get(): mixed;

  /**
   * Validate the parameter value.
   *
   * @param mixed $value
   *   The value of the parameter.
   *
   * @return array
   *   An array of strings describing validation errors. If this is empty,
   *   validation was successful.
   */
  public function validate($value): array;

}
