<?php

namespace Drupal\rest_easy_openapi\Plugin\Derivative;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Core\Plugin\Discovery\ContainerDeriverInterface;
use Drupal\rest_easy\Plugin\APIManager;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * A plugin deriver that converts REST Easy APIs into OpenAPI documentation.
 *
 * @package Drupal\rest_easy_openapi\Plugin\Derivative
 */
class RESTEasyApiDeriver extends DeriverBase implements ContainerDeriverInterface {

  /**
   * REST Easy API plugin manager service.
   *
   * @var \Drupal\rest_easy\Plugin\APIManager
   */
  protected APIManager $apiManager;

  /**
   * Constructs a new RESTEasyApiDeriver object.
   *
   * @param \Drupal\rest_easy\Plugin\APIManager $apiManager
   *   REST Easy API plugin manager service.
   */
  public function __construct(APIManager $apiManager) {
    $this->apiManager = $apiManager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, $base_plugin_id) {
    return new static(
      $container->get('plugin.manager.rest_easy.api')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getDerivativeDefinitions($base_plugin_definition) {
    foreach ($this->apiManager->getDefinitions() as $plugin_id => $api_plugin) {
      $this->derivatives[$plugin_id] = $base_plugin_definition;
      $this->derivatives[$plugin_id]['id'] = $plugin_id;
      $this->derivatives[$plugin_id]['label'] = $api_plugin['label'];
    }
    return $this->derivatives;
  }

}
