<?php

namespace Drupal\rest_easy\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\rest_easy\Plugin\EndpointInterface;
use Symfony\Component\HttpFoundation\Response;

/**
 * An event that is dispatched when an endpoint is called.
 *
 * @package Drupal\rest_easy\Event
 */
class EndpointCallEvent extends Event {
  public const EVENT_NAME = 'rest_easy_endpoint_call_event';

  /**
   * The endpoint plugin being called.
   *
   * @var \Drupal\rest_easy\Plugin\EndpointInterface
   */
  public EndpointInterface $endpoint;

  /**
   * The response object about to be returned.
   *
   * @var \Symfony\Component\HttpFoundation\Response
   */
  public Response $response;

  /**
   * Constructs a new EndpointCallEvent object.
   *
   * @param \Drupal\rest_easy\Plugin\EndpointInterface $endpoint
   *   The endpoint plugin being called.
   * @param \Symfony\Component\HttpFoundation\Response $response
   *   The response object about to be returned.
   */
  public function __construct(EndpointInterface $endpoint, Response $response) {
    $this->endpoint = $endpoint;
    $this->response = $response;
  }

}
