/**
 * @file
 * Define behavior for the API keys form.
 */

Drupal.behaviors.RESTEasyAPIKeysForm = {
  attach: function (context) {
    /**
     * Generate a UUID.
     *
     * @return {string}
     *   The generated UUID
     *
     * @see http://stackoverflow.com/a/8809472
     */
    function generateUUID() {
      let d = new Date().getTime();
      if (window.performance && typeof window.performance.now === "function") {
        d += performance.now();
      }
      return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(
        /[xy]/g,
        function (c) {
          const r = (d + Math.random() * 16) % 16 | 0;
          d = Math.floor(d / 16);
          return (c == "x" ? r : (r & 0x3) | 0x8).toString(16);
        }
      );
    }

    // Use the once() method to ensure this code runs only once per element.
    const generateButton = once(
      "RESTEasyAPIKeysForm",
      ".generate-api-key",
      context
    );
    generateButton.forEach((element) => {
      console.log("Adding");
      element.addEventListener("click", (event) => {
        event.preventDefault();

        // Generate a UUID and add it to the textarea.
        const uuid = generateUUID();
        const apiKeyTextarea = document.getElementById(
          "edit-rest-easy-api-keys"
        );
        apiKeyTextarea.value = (apiKeyTextarea.value + "\n" + uuid).trim();
      });
    });
  },
};
