<?php
namespace Drupal\rest_mail_login\Controller;
use Drupal\user\Controller\UserAuthenticationController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Exception\BadRequestHttpException;

/**
 * Provides controller for login, login status and logout via HTTP requests.
 */
class RestMailLoginController extends UserAuthenticationController {

  /**
   * Logs in a user.
   *
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   The request.
   *
   * @return \Symfony\Component\HttpFoundation\Response
   *   A response which contains the ID and CSRF token.
   */
  public function login(Request $request) {
    $format = $this->getRequestFormat($request);
    $content = $request->getContent();
    $credentials = $this->serializer->decode($content, $format);
    if (!isset($credentials['mail'])) {
      throw new BadRequestHttpException('Missing credentials.mail.');
    }
    $user = user_load_by_mail($credentials['mail']);
    if(!$user){
      throw new BadRequestHttpException('Invalid credentials.mail.');
    }
    unset($credentials['mail']);
    $credentials['name'] = $user->getAccountName();
    $serialized = $this->serializer->encode($credentials,$format);
    $newRequest = Request::create(
      $request->getRequestUri(),
      $request->getMethod(),
      $request->request->all(),
      $request->cookies->all(),
      $request->files->all(),
      $request->server->all(),
      $serialized
    );
    $newRequest->setRequestFormat($format);
    $response = parent::login($newRequest);
    return $response;
  }
}
