<?php
namespace Drupal\rest_password_reset\Access;

use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Access check for the rest password reset configuration.
 */
final class PasswordResetAccessCheck {

  /**
   * Checks access for the rest password reset configuration.
   *
   * @param \Drupal\Core\Session\AccountInterface $account
   *   The user account to check access for.
   *
   * @return \Drupal\Core\Access\AccessResult
   *   The access result.
   */
  public function checkAccess(AccountInterface $account) {
    return AccessResult::allowedIf(
      $account->hasPermission('administer site configuration')
      || $account->hasPermission('rest password reset')
    );
  }

}
