<?php

namespace Drupal\rest_register_verify_email\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\RedirectResponse;

/**
 * Class ResendController.
 */
class ResendController extends ControllerBase {
  public function resend($user, Request $request) {
    // Check if account is unverified.
    if (empty($user->getLastAccessedTime())) {
      // Resend verify account token mail.
      _rest_register_verify_email_user_mail_notify('email_verify_register_rest', $user);
      \Drupal::messenger()->addStatus('Account verification mail was resent to ' . $user->getAccountName() . '.');
    } else {
      \Drupal::messenger()->addError('This account has already been verfied.');
    }
    $previousUrl = $request->headers->get('referer');
    $response = new RedirectResponse($previousUrl);
    return $response;
  }
}
