<?php

namespace Drupal\restaurant_order\Entity;

use Drupal\Core\Entity\ContentEntityBase;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Field\BaseFieldDefinition;

/**
 * Defines the Menu Item entity.
 *
 * @ContentEntityType(
 *   id = "menu_item",
 *   label = @Translation("Menu Item"),
 *   base_table = "menu_item",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "name"
 *   },
 *   handlers = {
 *     "form" = {
 *       "default" = "Drupal\restaurant_order\Form\MenuItemForm"
 *     },
 *     "list_builder" = "Drupal\Core\Entity\EntityListBuilder"
 *   },
 *   admin_permission = "administer menu items"
 * )
 */
class MenuItem extends ContentEntityBase {

  /**
   *
   */
  public static function baseFieldDefinitions(EntityTypeInterface $entity_type) {
    $fields = [];

    $fields['id'] = BaseFieldDefinition::create('integer')->setReadOnly(TRUE);

    $fields['name'] = BaseFieldDefinition::create('string')
      ->setLabel(t('Name'))
      ->setRequired(TRUE);

    $fields['category'] = BaseFieldDefinition::create('string')
      ->setLabel(t('Category'));

    $fields['price'] = BaseFieldDefinition::create('decimal')
      ->setLabel(t('Price'))
      ->setSetting('scale', 2);

    $fields['type'] = BaseFieldDefinition::create('list_string')
      ->setLabel(t('Type'))
      ->setSettings([
        'allowed_values' => [
          'food' => 'Food',
          'drink' => 'Drink',
        ],
      ]);

    return $fields;
  }

}
