<?php

namespace Drupal\restaurant_order\Entity;

use Drupal\Core\Entity\ContentEntityBase;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Field\BaseFieldDefinition;

/**
 * Defines the Order entity.
 *
 * @ContentEntityType(
 *   id = "restaurant_order",
 *   label = @Translation("Order"),
 *   base_table = "restaurant_order",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "table_no"
 *   },
 *   handlers = {
 *     "form" = {
 *       "default" = "Drupal\restaurant_order\Form\OrderForm"
 *     },
 *     "list_builder" = "Drupal\Core\Entity\EntityListBuilder"
 *   },
 *   admin_permission = "administer restaurant orders"
 * )
 */
class Order extends ContentEntityBase {

  /**
   *
   */
  public static function baseFieldDefinitions(EntityTypeInterface $entity_type) {
    $fields = [];

    $fields['id'] = BaseFieldDefinition::create('integer')->setReadOnly(TRUE);

    $fields['table_no'] = BaseFieldDefinition::create('string')
      ->setLabel(t('Table No'))
      ->setRequired(TRUE);

    $fields['items'] = BaseFieldDefinition::create('map')
      ->setLabel(t('Items'))
      ->setDescription('Stores ordered items with quantity.');

    $fields['status'] = BaseFieldDefinition::create('list_string')
      ->setLabel(t('Status'))
      ->setDefaultValue('pending')
      ->setSettings([
        'allowed_values' => [
          'pending' => 'Pending',
          'served' => 'Served',
          'billed' => 'Billed',
        ],
      ]);

    return $fields;
  }

}
