<?php

namespace Drupal\restaurant_order\Entity;

use Drupal\Core\Entity\ContentEntityBase;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Field\BaseFieldDefinition;

/**
 *
 */
class RestaurantOrder extends ContentEntityBase {

  /**
   *
   */
  public static function baseFieldDefinitions(EntityTypeInterface $entity_type) {
    $fields = [];

    $fields['id'] = BaseFieldDefinition::create('integer')->setReadOnly(TRUE);

    $fields['table_no'] = BaseFieldDefinition::create('string')
      ->setLabel(t('Table No'))
      ->setRequired(TRUE);

    $fields['items'] = BaseFieldDefinition::create('string')
      ->setLabel(t('Items'))
      ->setSetting('max_length', 10000);

    $fields['status'] = BaseFieldDefinition::create('list_string')
      ->setLabel(t('Status'))
      ->setDefaultValue('pending')
      ->setSettings([
        'allowed_values' => [
          'pending' => 'Pending',
          'served' => 'Served',
          'billed' => 'Billed',
        ],
      ]);

    $fields['created'] = BaseFieldDefinition::create('created')
      ->setLabel(t('Created'));

    return $fields;
  }

}
