<?php

namespace Drupal\restaurant_order\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Form\ConfirmFormBase;
use Drupal\Core\Url;

/**
 * Delete confirmation for menu items.
 */
class MenuItemDeleteForm extends ConfirmFormBase {
  protected $id;

  /**
   *
   */
  public function getFormId() {
    return 'restaurant_order_menu_item_delete_form';
  }

  /**
   *
   */
  public function getQuestion() {
    return $this->t('Are you sure you want to delete this menu item?');
  }

  /**
   *
   */
  public function getCancelUrl() {
    return new Url('restaurant_order.menu_items');
  }

  /**
   *
   */
  public function getConfirmText() {
    return $this->t('Delete');
  }

  /**
   *
   */
  public function buildForm(array $form, FormStateInterface $form_state, $id = NULL) {
    $this->id = $id;
    return parent::buildForm($form, $form_state);
  }

  /**
   *
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    \Drupal::database()->delete('menu_item')->condition('id', $this->id)->execute();
    \Drupal::messenger()->addMessage($this->t('Menu item deleted.'));
    $form_state->setRedirect('restaurant_order.menu_items');
  }

}
