<?php

namespace Drupal\restaurant_order\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Add/Edit Menu Item form.
 */
class MenuItemForm extends FormBase {

  /**
   *
   */
  public function getFormId() {
    return 'restaurant_order_menu_item_form';
  }

  /**
   *
   */
  public function buildForm(array $form, FormStateInterface $form_state, $id = NULL) {
    $menu_item = NULL;
    if ($id) {
      $menu_item = \Drupal::database()->select('menu_item', 'm')->fields('m')->condition('id', $id)->execute()->fetchObject();
    }

    $form['id'] = ['#type' => 'hidden', '#value' => $id];

    $form['name'] = ['#type' => 'textfield', '#title' => $this->t('Name'), '#required' => TRUE, '#default_value' => $menu_item ? $menu_item->name : ''];
    $form['category'] = [
      '#type' => 'select',
      '#title' => $this->t('Category'),
      '#options' => [
        'starter' => $this->t('Starter'),
        'main_course' => $this->t('Main Course'),
        'dessert' => $this->t('Dessert'),
        'beverage' => $this->t('Beverage'),
      ],
      '#required' => TRUE,
      '#default_value' => $menu_item ? $menu_item->category : 'starter',
    ];
    $form['price'] = ['#type' => 'number', '#title' => $this->t('Price'), '#step' => '0.01', '#required' => TRUE, '#default_value' => $menu_item ? $menu_item->price : ''];
    $form['type'] = ['#type' => 'select', '#title' => $this->t('Type'), '#options' => ['food' => $this->t('Food'), 'drink' => $this->t('Drink')], '#default_value' => $menu_item ? $menu_item->type : 'food'];

    $form['actions'] = ['#type' => 'actions'];
    $form['actions']['submit'] = ['#type' => 'submit', '#value' => $this->t('Save')];
    $form['#cache'] = ['max-age' => 0];
    return $form;
  }

  /**
   *
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $id = $form_state->getValue('id');
    $values = [
      'name' => $form_state->getValue('name'),
      'category' => $form_state->getValue('category'),
      'price' => $form_state->getValue('price'),
      'type' => $form_state->getValue('type'),
    ];

    if ($id) {
      \Drupal::database()->update('menu_item')->fields($values)->condition('id', $id)->execute();
      \Drupal::messenger()->addMessage($this->t('Menu item updated.'));
    }
    else {
      \Drupal::database()->insert('menu_item')->fields($values)->execute();
      \Drupal::messenger()->addMessage($this->t('Menu item added.'));
    }

    $form_state->setRedirect('restaurant_order.menu_items');
  }

}
