# Reverse Proxy Header

This module is the simplest way to use the specific HTTP header name
to determine the client IP. The most common usage is:
- real client IP is stored inside a non-default header HTTP_X_FORWARDED_FOR;
- you have no ability to affect this on reverse proxy or server sides.

___

The module provides an equivalent of `reverse_proxy_header` setting (which is
deprecated from Drupal 8.7.0). @see https://www.drupal.org/node/3030558

How to use it:
- Step 1) Install and enable the module.
- Step 2) Add the `reverse_proxy_header` setting to your setting.php file:
```
/**
 * Sets the HTTP header name which stores real client IP.
 *
 * This setting may be affected by:
 *  - $settings['reverse_proxy'] (Drupal Core setting);
 *  - $settings['reverse_proxy_addresses'] (Drupal Core setting);
 *  - $settings['reverse_proxy_header_trusted_addresses_ignore'] (this module).
 *
 * @see https://www.drupal.org/project/reverse_proxy_header
 */
$settings['reverse_proxy_header'] = 'HTTP_X_FORWARDED_FOR_CUSTOM_HEADER';

/**
 * Allows ignore reverse_proxy_header not from trusted proxies addresses.
 *
 * This setting takes effect only if the $settings['reverse_proxy'] (Drupal Core
 * setting) is set to TRUE.
 *
 * If the addresses of trusted proxies are configured and this setting is set
 * to FALSE (the default value), the header value will be used only from trusted
 * proxies.
 *
 * If the addresses of trusted proxies are not configured or this setting is set
 * to TRUE, the value from the specified header name will always be used as a
 * real client IP (if a valid IP address is provided in it). However, this would
 * likely allow IP address spoofing unless more advanced precautions are taken.
 *
 * @see Drupal Core documentation (default.settings.php) for
 * $settings['reverse_proxy'] and $settings['reverse_proxy_addresses'].
 * @see https://www.drupal.org/project/reverse_proxy_header
 */
$settings['reverse_proxy_header_trusted_addresses_ignore'] = FALSE;
```

___

What about available alternatives?
- rename the header name (or copy its value) to the supported header
  HTTP_X_FORWARDED_FOR on proxy or server side;
- copy the value from the custom header to $_SERVER['HTTP_X_FORWARDED_FOR']
  in your index.php before Drupal initialization.
