# Reviewer Notes

Lightweight reviewing/annotation tool for Drupal. Lets reviewers add tagged notes anchored to any section of a page, filter them by tags, review activity logs and comments, and export all notes from an admin report.

## Table of Contents
- [Features](#features)
- [Key Benefits](#key-benefits)
- [Requirements](#requirements)
- [Installation](#installation)
- [Configuration](#configuration)
- [Using the overlay](#using-the-overlay)
- [Admin report and export](#admin-report-and-export)
- [Security & CSRF](#security--csrf)
- [Endpoints (summary)](#endpoints-summary)
- [Uninstall](#uninstall)
- [Troubleshooting](#troubleshooting)
- [Maintainers](#maintainers)

## Features
- Two note types: Annotated element (anchors to an HTML element) and Quick note (page-level)
- Add/edit/delete notes anchored to any element on the page (via “Pick element” or quick note)
- Tag notes and filter with OR logic (comma/space separated)
- “Go to” scrolls to the anchored element (selector fallback and Y-position)
- Status workflow: Open ↔ Resolved (live updates, logs recorded)
- Activity logs and per-note comments with user display and UID
- Admin report (filter by path/tags) with CSV export

## Key Benefits
- Faster review cycles: capture feedback in-context on any page element
- Clear traceability: logs and comments provide an audit trail per note
- Flexible triage: tag-based OR filtering with quick click-to-filter chips
- Minimal friction: quick notes for page-level feedback without anchors
- Safe in production: optional CSRF protection for all POST endpoints
- Works across aliases: URL rules consider both alias and system path

## Requirements
- Drupal 10/11
- Permissions: grant users “view reviewer notes”; add/edit/delete as needed

## Installation
1. Place this module in `modules/custom/reviewer_notes`.
2. Enable “Reviewer Notes” at Extend.
3. Configure at Configuration → Content authoring → Reviewer Notes.

## Configuration
In “Reviewer Notes” settings you can control:
- Enable: master switch to show/hide the overlay globally
- CSRF protect (POST endpoints): strongly recommended for production
- URL patterns: supports `*`; matched against both URL alias (e.g. `/about-us`) and system path (e.g. `/node/123`)
- Negate URL patterns: treat patterns as an exclusion list

Admin UI provides two tabs:
- Settings: the controls above
- Report: browse all notes with filters and CSV export

Tip: Clear caches after changing configuration.

## Using the overlay
- The overlay appears at the bottom of pages allowed by your URL rules.
- Two ways to add notes:
  - Annotated element: click “Pick element” and then click any element on the page to anchor your note.
  - Quick note: creates a page-level note without a specific anchor (no “Go to” button).
- Tags: click a tag chip to add it to the filter input; filter accepts comma/space separators and matches with OR logic.
- Counters: shows filtered/total and Open vs Resolved counts.
- Logs & Comments: toggle on each note. Adding a comment updates both comments and logs via AJAX.

## Admin report and export
- Navigate to Configuration → Content authoring → Reviewer Notes → “Report” tab.
- Filter by path substring and/or tags; click “Export CSV” to download the filtered results.

## Security & CSRF
- CSRF protection for POST endpoints is configurable at “Reviewer Notes settings”. When enabled (recommended for production), the frontend fetches tokens from `/session/token` and sends `X-CSRF-Token` headers; the backend validates them.
- If you see 403 on POST requests during local development, ensure:
  - `settings.php` includes trusted host patterns for your domain
  - `cookie_secure` is FALSE for HTTP, and `session.cookie_samesite` is `Lax`

## Endpoints (summary)
- GET `/reviewer-notes/list?path=...`
- POST `/reviewer-notes/add` (CSRF-protected if enabled)
- POST `/reviewer-notes/update` (CSRF-protected if enabled)
- POST `/reviewer-notes/{id}/delete` (CSRF-protected if enabled)
- GET `/reviewer-notes/{id}/logs`
- GET `/reviewer-notes/{id}/comments`
- POST `/reviewer-notes/{id}/comments/add` (CSRF-protected if enabled)

## Uninstall
- Uninstalling drops the module tables (`reviewer_notes`, `reviewer_notes_log`, `reviewer_notes_comment`) and removes `reviewer_notes.settings` config.

## Troubleshooting
- Overlay not showing: check permissions, the master Enable toggle, and URL patterns. Clear caches.
- “Filter”/“Export” on report: uses GET query params; ensure the admin menu/tabs are visible (clear caches).
- Buttons not responding: hard-reload the browser to ensure latest JS.

## Maintainers
Current maintainer(s):
- Neeraj Singh (neerajsingh) - https://www.drupal.org/u/neerajsingh
- Contributions welcome via issues and pull requests.
