<?php

/**
 * @file
 * Builds placeholder replacement tokens for drush report.
 */

use Drupal\Core\Render\BubbleableMetadata;

/**
 * Implements hook_token_info().
 */
function revision_extras_token_info() {
  $info = [];

  $info['types']['revision_extras'] = [
    'name' => t('Revision extras tokens'),
    'description' => t('Tokens provided by revision extras.'),
    'needs-data' => 'report_date',
  ];

  $info['tokens']['revision_extras'] = [
    'report_date' => [
      'name' => t('Report Date'),
      'description' => t('The date for the drush changed content report.'),
      'type' => 'date',
    ],
    'report_results' => [
      'name' => t('Report Results'),
      'description' => t('The data for the drush changed content report.'),
    ],
  ];

  return $info;
}

/**
 * Implements hook_tokens().
 */
function revision_extras_tokens($type, $tokens, array $data, array $options, BubbleableMetadata $bubbleable_metadata) {
  $replacements = [];

  if ($type === 'revision_extras' && !empty($data['report_date'])) {
    $replacements['[revision_extras:report_date]'] = $data['report_date'];

    if (!empty($data['report_results'])) {
      $replacements['[revision_extras:report_results]'] = $data['report_results'];
    }
  }
  return $replacements;
}
