<?php

/**
 * @file
 * Builds placeholder replacement tokens for drush report.
 */

use Drupal\Core\Render\BubbleableMetadata;

/**
 * Implements hook_token_info().
 */
function revision_extras_token_info() {
  $info = [];

  // Drush report tokens.
  $info['types']['revision_extras'] = [
    'name' => t('Revision extras tokens'),
    'description' => t('Tokens provided by revision extras.'),
    'needs-data' => 'report_date',
  ];

  $info['tokens']['revision_extras'] = [
    'report_date' => [
      'name' => t('Report Date'),
      'description' => t('The date for the drush changed content report.'),
      'type' => 'date',
    ],
    'report_results' => [
      'name' => t('Report Results'),
      'description' => t('The data for the drush changed content report.'),
    ],
  ];

  // Log message tokens.
  // Node log message is handled by token module.
  $entity_types = [
    'media',
    'block_content',
  ];
  foreach ($entity_types as $entity_type) {
    if (\Drupal::moduleHandler()->moduleExists($entity_type)) {
      $info['tokens'][$entity_type]['log'] = [
        'name' => t('Revision log message'),
        'description' => t('The explanation of the most recent changes made to the %type.', ['%type' => $entity_type]),
      ];
    }
  }

  return $info;
}

/**
 * Implements hook_tokens().
 */
function revision_extras_tokens($type, $tokens, array $data, array $options, BubbleableMetadata $bubbleable_metadata) {
  $replacements = [];

  // Drush report tokens.
  if ($type === 'revision_extras' && !empty($data['report_date'])) {
    $replacements['[revision_extras:report_date]'] = $data['report_date'];

    if (!empty($data['report_results'])) {
      $replacements['[revision_extras:report_results]'] = $data['report_results'];
    }
  }

  // Log message tokens.
  $entity_types = [
    'media',
    'block_content',
  ];
  foreach ($entity_types as $entity_type) {
    if ($type === $entity_type && !empty($data[$entity_type])) {
      $entity = $data[$entity_type];
      $entity_def = $entity->getEntityType();
      $revision_log_field = $entity_def->getRevisionMetadataKey('revision_log_message');

      foreach ($tokens as $name => $original) {
        if ($name === 'log') {
          $replacements[$original] = (string) $entity->{$revision_log_field}->value;
        }
      }
    }
  }

  return $replacements;
}
