<?php

declare(strict_types=1);

namespace Drupal\Tests\revision_extras\Kernel;

use Drupal\block_content\Entity\BlockContent;
use Drupal\block_content\Entity\BlockContentType;
use Drupal\media\Entity\Media;
use Drupal\Tests\media\Kernel\MediaKernelTestBase;

/**
 * Class to test revision extra tokens.
 *
 * @group revision_extras
 */
class RevisionExtrasTokenTest extends MediaKernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'revision_extras',
    'token',
    'block_content',
  ];

  /**
   * Token service.
   *
   * @var \Drupal\Core\Utility\Token
   */
  protected $tokenService;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->installEntitySchema('block_content');

    $this->tokenService = $this->container->get('token');
  }

  /**
   * Test that the media log message token returns expected value.
   */
  public function testMediaLogMessageTokenValue() {
    $log_message = 'My example log message.';
    $media = Media::create([
      'bundle' => $this->testMediaType->id(),
      'name' => 'Unnamed',
    ]);
    $media->setRevisionLogMessage($log_message);
    $media->save();

    $this->assertSame($log_message, $this->tokenService->replace('[media:log]', ['media' => $media]));
  }

  /**
   * Test that the block content log message token returns expected value.
   */
  public function testBlockContentLogMessageTokenValue() {
    $log_message = 'My example log message.';
    // Create a block content type.
    BlockContentType::create([
      'id' => 'spiffy',
      'label' => 'Very spiffy',
      'description' => "Provides a block type that increases your site's spiffy rating by up to 11%",
    ])->save();
    // And a block content entity.
    $block_content = BlockContent::create([
      'info' => 'Spiffy prototype',
      'type' => 'spiffy',
    ]);
    $block_content->setRevisionLogMessage($log_message);
    $block_content->save();

    $this->assertSame($log_message, $this->tokenService->replace('[block_content:log]', ['block_content' => $block_content]));
  }

}
