<?php

namespace Drupal\revision_manager\Plugin;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\revision_manager\Annotation\RevisionManager;

/**
 * Manages RevisionManager plugins.
 */
final class RevisionManagerPluginManager extends DefaultPluginManager {

  /**
   * Array of merged settings from config and node type third party settings.
   */
  protected array $settings = [];

  /**
   * Constructs the RevisionManagerPluginManager object.
   */
  public function __construct(
    \Traversable $namespaces,
    CacheBackendInterface $cacheBackend,
    ModuleHandlerInterface $moduleHandler,
    protected ConfigFactoryInterface $configFactory,
  ) {
    parent::__construct(
      'Plugin/RevisionManager',
      $namespaces,
      $moduleHandler,
      RevisionManagerInterface::class,
      RevisionManager::class,
    );
    $this->alterInfo('revision_manager_info');
    $this->setCacheBackend($cacheBackend, 'revision_manager_plugins');
  }

  /**
   * Retrieve the configured plugin instance.
   */
  public function getPlugin(string $plugin_id, string $entity_type, ?array $configuration = NULL): RevisionManagerInterface {
    $configuration = $configuration ?? $this->getDefaultPluginSettings($plugin_id, $entity_type)['settings'] ?? [];
    return $this->createInstance($plugin_id, $configuration);
  }

  /**
   * Gets the default settings for a plugin.
   */
  public function getDefaultPluginSettings(string $plugin_id, string $entity_type): array {
    $config = $this->configFactory->get('revision_manager.settings');
    return $config->get('defaults')[$entity_type][$plugin_id] ?? [];
  }

}
