# Revision Manager

## CONTENTS OF THIS FILE

* Introduction
* Requirements
* Installation
* Configuration
* Maintainers

## INTRODUCTION

The Revision Manager module provides complete control over how revisions are retained and cleaned up across all revisionable entity types and bundles. Every policy and behavior is fully customizable, allowing you to preserve important content history while automatically removing outdated revisions. Whether you need to keep a minimum number of revisions, delete revisions older than a set age, or implement custom retention strategies, Revision Manager gives you full flexibility over revision management.

Inspired by Node Revision Delete, this module extends similar functionality beyond nodes to all revisionable entity types, with optimizations designed for sites managing a high number of revisions.

**Supported Entities**
- Nodes
- Media
- Block content
- Taxonomy terms
- Menu Links
- Groups
- and more...


## REQUIREMENTS
This module requires no modules outside of Drupal core.

## INSTALLATION
The installation of this module is like other Drupal modules.

1. If your site is [managed via Composer](https://www.drupal.org/node/2718229),
   use Composer to download the revision_manager module running
   ```composer require "drupal/revision_manager"```. Otherwise copy/upload the revision_manager
   module to the modules directory of your Drupal installation.

2. Enable the 'Revision Manager' module and desired sub-modules in 'Extend'.
   (`/admin/modules`)

3. Set up user permissions. (`/admin/people/permissions/module/revision_manager`)

## CONFIGURATION

### SETTINGS

Configure the module at: ``/admin/config/content/revision-manager``:

- **Entity Type Settings**: Configure revision management at the entity type level with plugin-specific settings.
  - **Enabled** - Toggle whether an entity type should be included in the revision management process.
  - **Amount** - Delete revisions to maintain a minimum count.
  - **Age** - Delete revisions older than a specified age.

- **Bundle Settings**: Fine-tune revision policies for individual bundles that override the broader entity type settings. This allows for precise control at the most granular level.
- **Log activities to watchdog**: Generate detailed logs about revision deletions.
- **Disable automatic queueing**: Enable/disable automatic queueing when entities are updated.
- **Enqueue enabled entities for revision deletion**: Trigger immediate revision cleanup batch operations.

### DRUSH COMMANDS

``drush rm:queue`` - Queue all enabled entities for revision deletion processing.

## MAINTAINERS

Current maintainers:
 * Jordan Barnes (j-barnes) - https://www.drupal.org/u/j-barnes

