<?php

namespace Drupal\revision_manager\Drush\Commands;

use Drush\Commands\DrushCommands;
use Drush\Attributes as CLI;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\revision_manager\RevisionManagerBatchInterface;

/**
 * Commands to enqueue entities for revision removal.
 */
final class RevisionManagerCommands extends DrushCommands {

  public function __construct(
    private readonly RevisionManagerBatchInterface $revisionManagerBatch,
  ) {
    parent::__construct();
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container): static {
    return new static(
      $container->get('revision_manager.batch'),
    );
  }

  /**
   * Enqueues all enabled entities for revision cleanup.
   */
  #[CLI\Command(name: 'rm:queue')]
  #[CLI\Usage(name: 'drush rm:queue', description: 'Batch process and enqueue all configured entity types and will respect enabled plugins for revision cleanup.')]
  public function queueRevisions(): void {
    $this->io()->title('Batch Enqueueing Entities for Revision Cleanup');

    $result = $this->revisionManagerBatch->run(RevisionManagerBatchInterface::ENQUEUE_TYPE_DRUSH);

    if (!$result) {
      $this->io()->warning('No entities were found to queue for revision cleanup.');
      return;
    }

    $this->io()->success('Batch processing complete. Entities have been queued for revision cleanup.');
  }

}
