<?php

namespace Drupal\Tests\revision_manager\Kernel;

use Drupal\Core\Entity\RevisionableInterface;
use Drupal\Core\Entity\TranslatableInterface;

/**
 * Tests multilingual revision preservation.
 *
 * @group revision_manager
 */
class MultilingualPluginTest extends RevisionManagerTestBase {

  /**
   * Verify revisions kept across translation.
   */
  public function testSingleTranslation(): void {
    $this->configureRevisionManager('node', 'amount', TRUE, ['amount' => 3]);
    $node = $this->createEntity('node', ['type' => 'page', 'title' => 'Single Translation Test', 'status' => 1]);

    $this->assertInstanceOf(TranslatableInterface::class, $node);
    $this->assertInstanceOf(RevisionableInterface::class, $node);

    $translation = $node->addTranslation('es', ['title' => 'ES']);
    $translation->save();

    // Let the method detect which languages exist and create 5 each.
    $this->createRevisions($translation, 5);
    $this->processRevisionQueue(self::QUEUE_ID);

    // Verify the node has exactly 3 revisions remaining.
    $this->assertRevisionCount($node, 3);
  }

}
