<?php

namespace Drupal\revision_manager\Plugin;

use Drupal\Component\Plugin\ConfigurableInterface;
use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Plugin\PluginFormInterface;
use Drupal\Core\Entity\RevisionableInterface;

/**
 * Defines an interface for Revision Manager plugins.
 */
interface RevisionManagerInterface extends PluginInspectionInterface, ConfigurableInterface, PluginFormInterface, ContainerFactoryPluginInterface {

  /**
   * Delete revisions for a given entity.
   */
  public function deleteRevisions(RevisionableInterface $entity): array;

}
