/**
 * @file
 * Attaches revision manager behaviors to the entity form.
 */

(($, Drupal) => {
  Drupal.behaviors.revisionManagerSummaries = {
    attach: (context) => {
      $(context)
        .find('.revision-manager-settings-form')
        .drupalSetSummary(() => {
          const enabledPlugins = [];

          // Locate the plugin settings.
          $(context)
            .find('.revision-manager-plugin-settings')
            .each((_, plugin) => {
              const $plugin = $(plugin);
              if ($plugin.find('input:checked').length) {
                const pluginTitle = $plugin.find('summary').text().trim();
                if (pluginTitle) {
                  enabledPlugins.push(pluginTitle);
                }
              }
            });

          // Return a summary string based on the enabled plugins.
          return enabledPlugins.length ? Drupal.t('Enabled Plugins: ') + enabledPlugins.join(', ') : Drupal.t('Revision Manager is disabled.');
        });
    },
  };
})(jQuery, Drupal);
