<?php

namespace Drupal\Tests\revision_manager\Kernel;

use Drupal\block_content\Entity\BlockContentType;
use Drupal\KernelTests\Core\Entity\EntityKernelTestBase;
use Drupal\Tests\node\Traits\ContentTypeCreationTrait;
use Drupal\Tests\taxonomy\Traits\TaxonomyTestTrait;
use Drupal\Tests\media\Traits\MediaTypeCreationTrait;
use Drupal\Tests\revision_manager\Traits\TestRevisionManagerTrait;
use Drupal\language\Entity\ConfigurableLanguage;
use Drupal\group\Entity\GroupType;

/**
 * Base class for revision manager kernel tests.
 */
abstract class RevisionManagerTestBase extends EntityKernelTestBase {

  use TestRevisionManagerTrait;
  use ContentTypeCreationTrait;
  use TaxonomyTestTrait;
  use MediaTypeCreationTrait;

  /**
   * Queue used for Revision Manager revision deletion.
   */
  public const QUEUE_ID = 'revision_manager_remove_revisions';

  /**
   * Time constants.
   */
  protected const ONE_DAY = 86_400;
  protected const ONE_WEEK = 604_800;
  protected const ONE_MONTH = 2_592_000;

  /**
   * Modules required for the tests.
   *
   * @var string[]
   */
  protected static $modules = [
    'block',
    'block_content',
    'content_translation',
    'field',
    'file',
    'flexible_permissions',
    'filter',
    'group',
    'image',
    'language',
    'link',
    'media',
    'menu_link_content',
    'node',
    'path_alias',
    'revision_manager',
    'system',
    'taxonomy',
    'text',
    'user',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->container->get('plugin.manager.revision_manager')->clearCachedDefinitions();

    $this->installSchema('system', ['sequences']);
    $this->installSchema('node', ['node_access']);
    $this->installSchema('file', ['file_usage']);

    // Create additional languages for translation tests.
    ConfigurableLanguage::createFromLangcode('es')->save();
    ConfigurableLanguage::createFromLangcode('de')->save();

    foreach ([
      'user',
      'node',
      'taxonomy_term',
      'block_content',
      'file',
      'media',
      'group',
      'menu_link_content',
      'path_alias',
    ] as $schema) {
      $this->installEntitySchema($schema);
    }

    $this->installConfig([
      'system',
      'node',
      'taxonomy',
      'block_content',
      'media',
      'image',
      'revision_manager',
      'link',
      'group',
      'menu_link_content',
    ]);

    // Entities for testing.
    $this->createContentType(['type' => 'page', 'name' => 'Page', 'revision' => TRUE]);
    $this->createContentType(['type' => 'article', 'name' => 'Article', 'revision' => TRUE]);
    $this->createMediaType('file', ['id' => 'document', 'label' => 'Document', 'revision' => TRUE]);
    $this->createVocabulary(['vid' => 'tags', 'name' => 'Tags', 'revision' => TRUE]);
    BlockContentType::create(['id' => 'basic', 'label' => 'Basic', 'revision' => TRUE])->save();
    GroupType::create(['id' => 'test_group_type', 'label' => 'Test Group Type', 'revision' => TRUE])->save();
  }

}
