(function (Drupal, once) {
  Drupal.behaviors.revisionPurgatorySelectAll = {
    attach(context) {
      once('revision-purgatory-select-all', '#revision-purgatory-version-list-table', context).forEach(() => {
        const selectAll = document.getElementById('edit-table-select-all');
        if (!selectAll) {
          return;
        }

        selectAll.addEventListener('change', () => {
          const checkboxes = document.querySelectorAll('.revision-purgatory-row-checkbox');
          checkboxes.forEach((checkbox) => {
            checkbox.checked = selectAll.checked;
          });
        });

        document.addEventListener('change', (event) => {
          const target = event.target;
          if (target instanceof HTMLInputElement && target.classList.contains('revision-purgatory-row-checkbox')) {
            const checkboxes = document.querySelectorAll('.revision-purgatory-row-checkbox');
            if (!target.checked && selectAll.checked) {
              selectAll.checked = false;
            }
            else if (target.checked) {
              const allChecked = Array.from(checkboxes).every((checkbox) => checkbox.checked);
              if (allChecked) {
                selectAll.checked = true;
              }
            }
          }
        });
      });
    },
  };
})(Drupal, once);
