<?php

declare (strict_types=1);
namespace Drupal\rfc9557\Plugin\Validation\Constraint;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Symfony\Component\Validator\Constraint as SymfonyConstraint;
use Drupal\Core\Validation\Attribute\Constraint;

/**
 * RFC 9557 extended datetime validator.
 */
#[Constraint(
  id: 'Rfc9557',
  label: new TranslatableMarkup('RFC 9557 extended datetime', [], ['context' => 'Validation']),
)]
class Rfc9557 extends SymfonyConstraint {

  /**
   * Validate against RFC 9557.
   */
  public const MODE_STANDARDS = 'MODE_STANDARDS';

  /**
   * Strictly validate inconsistent time-offset and Time Zone combinations.
   */
  public const MODE_STRICT = 'MODE_STRICT';

  /**
   * @todo
   */
  public string $mode = self::MODE_STANDARDS;

  public const INVALID_TIMEZONE = '54b1f96a-d6ef-4402-90d8-330883426c11';
  public const INVALID_DATETIME = '44dcbe24-adf8-438b-b438-ab8c28c08d1b';
  public const OFFSET_INCONSISTENT = '8a9337e9-35dd-4064-9a26-47a8ba42fca3';

  /**
   * {@inheritdoc}
   */
  protected const ERROR_NAMES = [
    self::INVALID_TIMEZONE => 'INVALID_TIMEZONE',
    self::INVALID_DATETIME => 'INVALID_DATETIME',
    self::OFFSET_INCONSISTENT => 'OFFSET_INCONSISTENT',
  ];

  public string $invalidDatetimeMessage = 'Invalid datetime.';
  public string $invalidTimeZoneMessage = 'Invalid time zone.';
  public string $offsetInconsistentMessage = 'Inconsistent offset and time zone.';
}
