<?php

declare (strict_types=1);
namespace Drupal\rfc9557;

final class SuffixParts {

  public function __construct(
    public string $key,
    public string $value,
    public bool $critical = FALSE,
  ) {
  }

  public function toString(): string {
    return '['
      . ($this->critical ? '!' : '')
      . $this->key
      . '='
      . $this->value
      . ']';
  }

}
