<?php

declare (strict_types=1);
namespace Drupal\rfc9557;

/**
 * @implements \IteratorAggregate<int, \Drupal\rfc9557\SuffixParts>
 */
final class SuffixPartsList implements \IteratorAggregate, \Countable {

  /**
   * @param \Drupal\Rfc9557\SuffixParts[]
   */
  private array $suffixParts;

  public function __construct(
    ?SuffixParts ...$suffix_parts,
  ) {
    $this->suffixParts = $suffix_parts;
  }

  public function getIterator(): \Traversable {
    return new \ArrayIterator($this->suffixParts);
  }

  public function append(SuffixParts $suffix): void {
    $this->suffixParts[] = $suffix;
  }

  public function count(): int {
    return count($this->suffixParts);
  }

  public function toString(): string {
    return array_reduce($this->suffixParts, fn ($c, $suffix) => $c . $suffix->toString(), '');
  }

}
