<?php

declare (strict_types=1);

namespace Drupal\rfc9557\Model;

/**
 * RFC9557 date single suffix part.
 *
 * @see \Drupal\rfc9557\Model\SuffixPartsList
 */
final class SuffixParts {

  public function __construct(
    public string $key,
    public string $value,
    public bool $critical = FALSE,
  ) {
  }

  /**
   * Return this suffix part as a string.
   */
  public function toString(): string {
    return '['
      . ($this->critical ? '!' : '')
      . $this->key
      . '='
      . $this->value
      . ']';
  }

}
