<?php

declare (strict_types=1);

namespace Drupal\rfc9557\Model;

/**
 * List of RFC9557 suffix parts.
 *
 * @see \Drupal\rfc9557\Model\ExtendedDateTimeParts
 *
 * @implements \IteratorAggregate<int, \Drupal\rfc9557\Model\SuffixParts>
 */
final class SuffixPartsList implements \IteratorAggregate, \Countable {

  /**
   * The suffix parts.
   *
   * @param \Drupal\Rfc9557\SuffixParts[]
   *   The RFC9557 suffix parts.
   */
  private array $suffixParts;

  public function __construct(
    ?SuffixParts ...$suffix_parts,
  ) {
    $this->suffixParts = $suffix_parts;
  }

  /**
   * Get parts iterator.
   */
  public function getIterator(): \Traversable {
    return new \ArrayIterator($this->suffixParts);
  }

  /**
   * Append a part.
   */
  public function append(SuffixParts $suffix): void {
    $this->suffixParts[] = $suffix;
  }

  /**
   * Count parts.
   */
  public function count(): int {
    return count($this->suffixParts);
  }

  /**
   * Return this suffix list as a string.
   */
  public function toString(): string {
    return array_reduce($this->suffixParts, fn ($c, $suffix) => $c . $suffix->toString(), '');
  }

}
